<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
// admin/editar_producto.php
require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
require_once '../config/db.php';

if (!isset($_GET['id'])) { header("Location: productos.php"); exit; }
$id = $_GET['id'];

// Obtener datos
$stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
$stmt->execute([$id]);
$p = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$p) { header("Location: productos.php"); exit; }

$cats = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
$brands = $pdo->query("SELECT * FROM brands ORDER BY name")->fetchAll();

// Si el JSON viene vacío o nulo de la BD, poner '{}' para que no rompa JS
$specsJSON = $p['specifications'] ? $p['specifications'] : '{}';

// Función Slug Reutilizada
function limpiarNombre($string) {
    $string = trim($string);
    $string = str_replace(array('á','à','ä','â','ª','Á','À','Â','Ä'), array('a','a','a','a','a','A','A','A','A'), $string);
    $string = str_replace(array('é','è','ë','ê','É','È','Ê','Ë'), array('e','e','e','e','E','E','E','E'), $string);
    $string = str_replace(array('í','ì','ï','î','Í','Ì','Ï','Î'), array('i','i','i','i','I','I','I','I'), $string);
    $string = str_replace(array('ó','ò','ö','ô','Ó','Ò','Ö','Ô'), array('o','o','o','o','O','O','O','O'), $string);
    $string = str_replace(array('ú','ù','ü','û','Ú','Ù','Û','Ü'), array('u','u','u','u','U','U','U','U'), $string);
    $string = str_replace(array('ñ','Ñ','ç','Ç'), array('n','N','c','C'), $string);
    $string = preg_replace('/[^a-zA-Z0-9-]/', '-', $string);
    $string = strtolower($string);
    return $string;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Recibir datos
    $sku = $_POST['sku'];
    $name = $_POST['name'];
    $short_desc = $_POST['short_description'];
    $desc = $_POST['description'];
    $price = $_POST['price'];
    $cat_id = $_POST['category_id'];
    $brand_id = $_POST['brand_id'];
    $status = $_POST['status'];
    $specs = $_POST['specifications']; 
    
    // Lógica Renombrado de Imagen
    $new_slug = limpiarNombre($name);
    $imgName = $p['main_image_url'];
    $base_dir = "../public/img/productos/";

    // CASO 1: SUBE NUEVA FOTO
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $new_filename = $new_slug . "." . $ext;
        
        // Evitar colisión si existe otro archivo igual (y no es el actual)
        if (file_exists($base_dir . $new_filename) && $new_filename != $imgName) {
            $new_filename = $new_slug . "-" . time() . "." . $ext;
        }

        if (move_uploaded_file($_FILES['image']['tmp_name'], $base_dir . $new_filename)) {
            // Borrar vieja
            if ($imgName && $imgName != 'default_product.jpg' && file_exists($base_dir . $imgName)) {
                unlink($base_dir . $imgName);
            }
            $imgName = $new_filename;
        }
    } 
    // CASO 2: NO SUBE FOTO PERO CAMBIA NOMBRE -> RENOMBRAR
    elseif ($imgName && $imgName != 'default_product.jpg' && file_exists($base_dir . $imgName)) {
        $current_ext = pathinfo($imgName, PATHINFO_EXTENSION);
        $potential_new_name = $new_slug . "." . $current_ext;

        if ($imgName !== $potential_new_name) {
             if (!file_exists($base_dir . $potential_new_name)) {
                 rename($base_dir . $imgName, $base_dir . $potential_new_name);
                 $imgName = $potential_new_name;
             } else {
                 $potential_new_name = $new_slug . "-" . $id . "." . $current_ext;
                 rename($base_dir . $imgName, $base_dir . $potential_new_name);
                 $imgName = $potential_new_name;
             }
        }
    }

    $sql = "UPDATE products SET sku=?, name=?, short_description=?, description=?, price=?, category_id=?, brand_id=?, specifications=?, status=?, main_image_url=?, updated_at=NOW() WHERE id=?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$sku, $name, $short_desc, $desc, $price, $cat_id, $brand_id, $specs, $status, $imgName, $id]);

    echo "<script>window.location.href='productos.php';</script>";
}
?>

<main class="flex-1 overflow-y-auto p-6 md:p-8 relative">
    <div class="max-w-5xl mx-auto relative z-10">
        <div class="flex items-center gap-4 mb-8">
            <a href="productos.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-colors">
                <i class="ri-arrow-left-line text-xl"></i>
            </a>
            <h1 class="font-display font-black text-3xl text-gray-900 dark:text-white uppercase">Editar: <?php echo htmlspecialchars($p['name']); ?></h1>
        </div>

        <form method="POST" enctype="multipart/form-data" class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <div class="lg:col-span-2 space-y-6 bg-white dark:bg-brand-dark p-8 rounded-xl shadow-sm border border-gray-100 dark:border-white/5">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">SKU</label>
                        <input type="text" name="sku" value="<?php echo htmlspecialchars($p['sku']); ?>" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 text-gray-900 dark:text-white focus:border-brand-red outline-none">
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Nombre</label>
                        <input type="text" name="name" value="<?php echo htmlspecialchars($p['name']); ?>" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 text-gray-900 dark:text-white focus:border-brand-red outline-none">
                    </div>
                </div>

                <div class="bg-gray-50 dark:bg-black/20 p-6 rounded-xl border border-dashed border-gray-300 dark:border-white/10">
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-4 flex items-center gap-2">
                        <i class="ri-list-settings-line text-brand-red"></i> Especificaciones Técnicas
                    </label>
                    
                    <div class="flex gap-2 mb-4">
                        <input type="text" id="specKey" placeholder="Característica" class="flex-1 bg-white dark:bg-brand-dark border border-gray-200 dark:border-white/10 rounded-lg px-3 py-2 text-sm text-gray-900 dark:text-white outline-none focus:border-brand-red">
                        <input type="text" id="specValue" placeholder="Valor" class="flex-1 bg-white dark:bg-brand-dark border border-gray-200 dark:border-white/10 rounded-lg px-3 py-2 text-sm text-gray-900 dark:text-white outline-none focus:border-brand-red">
                        <button type="button" onclick="addSpec()" class="bg-gray-200 dark:bg-white/10 hover:bg-brand-red hover:text-white text-gray-600 dark:text-gray-300 px-4 py-2 rounded-lg transition-colors font-bold text-sm"><i class="ri-add-line"></i></button>
                    </div>

                    <ul id="specsList" class="space-y-2 mb-2"></ul>
                    <p id="noSpecsMsg" class="text-xs text-gray-400 italic text-center py-2 hidden">No hay especificaciones.</p>

                    <input type="hidden" name="specifications" id="specsJSON" value='<?php echo $specsJSON; ?>'>
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Descripción Corta</label>
                    <input type="text" name="short_description" value="<?php echo htmlspecialchars($p['short_description']); ?>" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 text-gray-900 dark:text-white focus:border-brand-red outline-none">
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Descripción Detallada</label>
                    <textarea name="description" rows="4" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 text-gray-900 dark:text-white focus:border-brand-red outline-none"><?php echo htmlspecialchars($p['description']); ?></textarea>
                </div>
            </div>

            <div class="space-y-6">
                <div class="bg-white dark:bg-brand-dark p-6 rounded-xl shadow-sm border border-gray-100 dark:border-white/5 space-y-6">
                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Precio (S/)</label>
                        <div class="relative">
                            <span class="absolute left-4 top-3 text-gray-400 font-bold">S/</span>
                            <input type="number" step="0.01" name="price" value="<?php echo $p['price']; ?>" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg pl-10 pr-4 py-3 font-black text-xl text-gray-900 dark:text-white focus:border-brand-red outline-none">
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Categoría</label>
                            <select name="category_id" required class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-2 py-3 text-sm text-gray-900 dark:text-white outline-none">
                                <?php foreach($cats as $c): ?>
                                    <option value="<?php echo $c['id']; ?>" <?php echo $c['id'] == $p['category_id'] ? 'selected' : ''; ?>><?php echo $c['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Marca</label>
                            <select name="brand_id" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-2 py-3 text-sm text-gray-900 dark:text-white outline-none">
                                <?php foreach($brands as $b): ?>
                                    <option value="<?php echo $b['id']; ?>" <?php echo $b['id'] == $p['brand_id'] ? 'selected' : ''; ?>><?php echo $b['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Estado</label>
                        <select name="status" class="w-full bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg px-4 py-3 text-gray-900 dark:text-white outline-none">
                            <option value="active" <?php echo $p['status'] == 'active' ? 'selected' : ''; ?>>Activo</option>
                            <option value="inactive" <?php echo $p['status'] == 'inactive' ? 'selected' : ''; ?>>Inactivo</option>
                        </select>
                    </div>
                </div>

                <div class="bg-white dark:bg-brand-dark p-6 rounded-xl shadow-sm border border-gray-100 dark:border-white/5">
                    <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-4">Imagen Principal</label>
                    
                    <label for="imageInput" class="cursor-pointer group relative flex flex-col items-center justify-center w-full h-64 border-2 border-dashed border-gray-300 dark:border-white/10 rounded-xl hover:border-brand-red transition-all bg-gray-50 dark:bg-black/20 overflow-hidden">
                        
                        <?php 
                            // RUTA CORREGIDA: ../public/img/productos/
                            $imgSrc = $p['main_image_url'] ? "../public/img/productos/".$p['main_image_url'] : "";
                            $hideClass = $imgSrc ? "" : "hidden";
                            $opacityClass = $imgSrc ? "opacity-0" : "";
                        ?>
                        
                        <img id="imagePreview" src="<?php echo $imgSrc; ?>" class="absolute inset-0 w-full h-full object-contain p-2 <?php echo $hideClass; ?> z-10">
                        
                        <div id="imagePlaceholder" class="flex flex-col items-center justify-center pt-5 pb-6 z-0 group-hover:scale-105 transition-transform <?php echo $opacityClass; ?>">
                            <div class="w-16 h-16 rounded-full bg-gray-100 dark:bg-white/5 flex items-center justify-center mb-3 text-gray-400 group-hover:text-brand-red group-hover:bg-brand-red/10 transition-colors">
                                <i class="ri-image-edit-line text-3xl"></i>
                            </div>
                            <p class="mb-2 text-sm text-gray-500 dark:text-gray-400">Clic para cambiar</p>
                        </div>
                        
                        <input id="imageInput" type="file" name="image" class="hidden" accept="image/*" onchange="previewImage(event)">
                    </label>
                </div>

                <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-display font-bold uppercase tracking-widest py-4 rounded-xl shadow-lg shadow-brand-red/20 transition-all transform active:scale-95">
                    Actualizar Producto
                </button>
            </div>
        </form>
    </div>
</main>

<script>
    // --- JS IDÉNTICO AL NUEVO, PERO CON CARGA INICIAL ---
    
    // 1. Imagen
    function previewImage(event) {
        const input = event.target;
        const preview = document.getElementById('imagePreview');
        const placeholder = document.getElementById('imagePlaceholder');

        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.classList.remove('hidden');
                placeholder.classList.add('opacity-0');
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    // 2. Especificaciones
    // Leemos el valor del input oculto que PHP llenó con datos de la BD
    let hiddenInput = document.getElementById('specsJSON');
    let specsObj = {};
    
    try {
        specsObj = JSON.parse(hiddenInput.value); // Convertir texto BD a Objeto JS
    } catch (e) {
        specsObj = {};
    }

    function renderSpecs() {
        const list = document.getElementById('specsList');
        const noMsg = document.getElementById('noSpecsMsg');
        
        list.innerHTML = '';
        const keys = Object.keys(specsObj);
        
        if (keys.length === 0) {
            noMsg.classList.remove('hidden');
        } else {
            noMsg.classList.add('hidden');
            keys.forEach(key => {
                const li = document.createElement('li');
                li.className = "flex justify-between items-center bg-white dark:bg-white/5 px-3 py-2 rounded border border-gray-100 dark:border-white/5";
                li.innerHTML = `
                    <span class="text-sm"><strong class="text-gray-700 dark:text-gray-300">${key}:</strong> <span class="text-gray-500">${specsObj[key]}</span></span>
                    <button type="button" onclick="removeSpec('${key}')" class="text-red-400 hover:text-red-600"><i class="ri-delete-bin-line"></i></button>
                `;
                list.appendChild(li);
            });
        }
        hiddenInput.value = JSON.stringify(specsObj);
    }

    function addSpec() {
        const keyInput = document.getElementById('specKey');
        const valInput = document.getElementById('specValue');
        const key = keyInput.value.trim();
        const val = valInput.value.trim();

        if (key && val) {
            specsObj[key] = val;
            keyInput.value = '';
            valInput.value = '';
            keyInput.focus();
            renderSpecs();
        }
    }

    function removeSpec(key) {
        delete specsObj[key];
        renderSpecs();
    }

    // Ejecutar al inicio para mostrar lo que hay en BD
    renderSpecs();
</script>

<?php require_once 'includes/footer.php'; ?>